#ifdef WIN32

#include "IMMgrHelper.h"
#include "csf/logger/CSFLogger.hpp"
#include "jcfcoreutils/StringUtils.h"
#include <csfunified/framework/UnifiedFactory.h>
#include "Dependence.h"
#include "imcmdDef.h"

#define IMCMD_DESKTOPSHARE_INVITATION_STRING	     L"Invite to webex desktop sharing session."
#define IMCMD_DESKTOPSHARE_DECLINE_STRING            L"Decline desktop sharing request."
#define IMCMD_DESKTOPSHARE_CANCELINVITATION_STRING	 L"Cancel desktop invitation request."

#define IMCMD_MEETING_INVITE_STRING                 L"Invite to webex meeting."
#define IMCMD_MEETING_DECLINE_STRING                 L"Decline webex meeting invite."
#define IMCMD_MEETING_CANCELINVITATION_STRING        L"Cancel webex meeting invite."

namespace CSFUnified
{
	static CSFLogger* JabberMeetingIMMgrLogger = CSFLogger_getLogger("MeetingService-JabberMeetingIMMgrLogger");

	IMMgrHelper::IMMgrHelper():m_pImProvider(NULL)
	{
		m_pCallback.reset();		
	}

	IMMgrHelper::~IMMgrHelper()
	{
		UnRegisterImCallback();
	}

	void IMMgrHelper::Init()
	{
		GetProvider();
	}

// 	stdapi IMMgrHelper::OnIMCmdReceived(IN ATUInt32 uCmd , IN const XM_TRI_IMCMD *pImCmd, OUT BOOL* vbHandled)
// 	{
// 		if (NULL == pImCmd || NULL == vbHandled)
// 		{
// 			return CON_S_FALSE;
// 		}
// 
// 		IJMIMCallback * pCallback = CDependence::getInstance()->GetIMCallback();
// 		if (NULL == pCallback)
// 		{
// 			return CON_S_FALSE;
// 		}
// 
// 		JabberWerxCommonHelper* m_pCommonHelper = CDependence::getInstance()->GetJabberWerxCommonHelper();
// 		if(NULL == m_pCommonHelper)
// 		{
// 			return FALSE;
// 		}
// 		wstring strAccountName = m_pCommonHelper->GetMyAccountName();
// 		wstring strSessionName = pImCmd->strSessionName;
// 		wstring strCmdMsg = pImCmd->strCmdMsg;
// 
// 		switch(uCmd)
// 		{
// 		case IMCMD_DESKTOPSHARE_INVITATION:
// 			{
// 				pCallback->OnRecv_DSInvitation(strAccountName, strSessionName, strCmdMsg);
// 				*vbHandled = ATTrue;
// 			}
// 			break;
// 		case IMCMD_DESKTOPSHARE_ACCEPT:
// 			{
// 				//this IM CMD is not used from C6.5, but we still need set it Handled here because C6 client may send this IM CMD
// 				*vbHandled = ATTrue;
// 			}
// 			break;			
// 		case IMCMD_DESKTOPSHARE_DECLINE:
// 			{
// 				pCallback->OnRecv_DSDecline(strAccountName, strSessionName, strCmdMsg);
// 				*vbHandled = ATTrue;
// 			}
// 			break;
// 		case IMCMD_DESKTOPSHARE_CANCELINVITATION:
// 			{
// 				pCallback->OnRecv_DSCancelled(strAccountName, strSessionName, strCmdMsg);
// 				*vbHandled = ATTrue;
// 			}
// 			break;
// 		////////////////////////////////////////////////////////////////////////// Meeting
// 		case IMCMD_MEETING_INVITE:
// 			{
// 				pCallback->OnRecv_MeetingInvitation(strAccountName, strSessionName, strCmdMsg);
// 				*vbHandled = ATTrue;
// 			}
// 			break;
// 		case IMCMD_MEETING_ACCEPT:
// 			{
// 				//this IM CMD is not used from C6.5, but we still need set it Handled here because C6 client may send this IM CMD
// 				*vbHandled = ATTrue;
// 			}
// 			break;
// 		case IMCMD_MEETING_DECLINE:
// 			{
// 				pCallback->OnRecv_MeetingDecline(strAccountName, strSessionName, strCmdMsg);
// 				*vbHandled = ATTrue;
// 			}
// 			break;
// 		case IMCMD_MEETING_CANCELINVITATION:
// 			{
// 				pCallback->OnRecv_MeetingCancelled(strAccountName, strSessionName, strCmdMsg);
// 				*vbHandled = ATTrue;
// 			}
// 			break;
// 		case IMCMD_WBXMEETING_INVITATE_ATTENDEES:
// 		case IMCMD_WBXMEETING_INVITATE_ATTENDEES_:
// 			{
// 				pCallback->OnRecv_IMAlert(strAccountName, strSessionName, strCmdMsg);
// 				*vbHandled = ATTrue;
// 			}
// 
// 		default:
// 			;
// 		}
// 
// 		return CON_S_OK ;
// 	}

	BOOL IMMgrHelper::SendCmd_DSInvitation(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage)
	{
		// jma modify for DE2208
		CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_DSInvitation entry.");
		CDependence *pDependence = CDependence::getInstance();
		if(pDependence != NULL)
		{
			CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_DSInvitation pDependence != NULL.");
			JabberWerxCommonHelper* pCommonHelper = pDependence->GetJabberWerxCommonHelper();
			if(pCommonHelper != NULL)
			{
				CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_DSInvitation pCommonHelper != NULL.");
				wstring enBuddyName = strBuddyName; //2013.3.7 fix DE2243 for change to JCF ----wstring enBuddyName = JCFCoreUtils::escapeJid(strBuddyName);
				if(pCommonHelper->IsBuddyOnline(enBuddyName) == ATTrue)
				{
					CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_DSInvitation call SendIMCmd.");
					return SendIMCmd(strBuddyName, IMCMD_DESKTOPSHARE_INVITATION, strCmd, strHtmlMessage, strPlainMessage, IMCMD_DESKTOPSHARE_INVITATION_STRING);
				}
			}
		}
		CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_DSInvitation return false.");
		return FALSE;

		//return SendIMCmd(strBuddyName, IMCMD_DESKTOPSHARE_INVITATION, strCmd, strHtmlMessage, strPlainMessage, IMCMD_DESKTOPSHARE_INVITATION_STRING);
		//wstring strInviteURL = strCmdMsg;
		//wstring strHtmlMsg, strPlainMsg;
		//return SendIMCmd(strSessionName, IMCMD_DESKTOPSHARE_INVITATION, strInviteURL, strHtmlMsg, strPlainMsg, IMCMD_DESKTOPSHARE_INVITATION_STRING);
	}

	BOOL IMMgrHelper::SendCmd_DSDecline(wstring& strSessionName, wstring& strCmdMsg)
	{
		CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_DSDecline()");
		return SendIMCmd(strSessionName, IMCMD_DESKTOPSHARE_DECLINE, L"", L"", L"", IMCMD_DESKTOPSHARE_DECLINE_STRING);
	}

	BOOL IMMgrHelper::SendCmd_DSCancelled(wstring& strSessionName, wstring& strCmdMsg)
	{
		CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_DSCancelled()");
		wstring strHtmlMsg, strPlainText;
		return SendIMCmd(strSessionName, IMCMD_DESKTOPSHARE_CANCELINVITATION, L"", strHtmlMsg, strPlainText, IMCMD_DESKTOPSHARE_CANCELINVITATION_STRING);
	}

	BOOL IMMgrHelper::SendCmd_MeetingInvitation(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage)
	{
		// jma modify for DE2208
		CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_MeetingInvitation entry.");
		CDependence *pDependence = CDependence::getInstance();
		if(pDependence != NULL)
		{
			CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_MeetingInvitation pDependence != NULL.");
			JabberWerxCommonHelper* pCommonHelper = pDependence->GetJabberWerxCommonHelper();
			if(pCommonHelper != NULL)
			{
				CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_MeetingInvitation pCommonHelper != NULL.");
				wstring enBuddyName = strBuddyName; //2013.3.7 fix DE2243 for change to JCF ----wstring enBuddyName = JCFCoreUtils::escapeJid(strBuddyName);
				if(pCommonHelper->IsBuddyOnline(enBuddyName) == ATTrue)
				{
					CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_MeetingInvitation call SendIMCmd.");
					return SendIMCmd(strBuddyName, IMCMD_MEETING_INVITE, strCmd, strHtmlMessage, strPlainMessage, IMCMD_MEETING_INVITE_STRING);
				}
			}
		}
		CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_MeetingInvitation return false.");
		return FALSE;
		//return SendIMCmd(strBuddyName, IMCMD_MEETING_INVITE, strCmd, strHtmlMessage, strPlainMessage, IMCMD_MEETING_INVITE_STRING);
	}

	BOOL IMMgrHelper::SendCmd_MeetingDecline(wstring& strSessionName, wstring& strCmdMsg)
	{
		CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_MeetingDecline()");
		return SendIMCmd(strSessionName, IMCMD_MEETING_DECLINE, L"", L"", L"", IMCMD_MEETING_DECLINE_STRING);
	}

	BOOL IMMgrHelper::SendCmd_MeetingCancelled(wstring& strSessionName, wstring& strCmdMsg)
	{
		 CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_MeetingCancelled()");
		 return SendIMCmd(strSessionName, IMCMD_MEETING_CANCELINVITATION, L"", L"", L"", IMCMD_MEETING_CANCELINVITATION_STRING);
	}

	BOOL IMMgrHelper::SendCmd_IMAlert(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage)
	{
		CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_IMAlert()");
		return SendIMCmd(strBuddyName, IMCMD_WBXMEETING_INVITATE_ATTENDEES_, strCmd,strHtmlMessage, strPlainMessage, L"");
	}

	void IMMgrHelper::SendCmd_CMRMeetingInvitation(const std::string& JID, const std::string& strCmdMsg, const std::string& htmlMsg, const std::string plainMsg)
	{
		CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendCmd_CMRMeetingInvitation()");
		SendIMCmdEx(JID, IMCMD_CMR_MEETING_INVITATION, strCmdMsg, htmlMsg, plainMsg, "");
	}

	void IMMgrHelper::SendAutoRespPolicy(wstring const& strBareJid, int eResult)
	{
		//getManager()->SendAutoRespPolicy(strBareJid, eResult);
	}



	BOOL IMMgrHelper::SendIMCmd(const wstring& strBuddyKey, INT cmd, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage, IN const wstring& strLogMsg)
	{
		//conHRESULT ret = getManager()->SendIMCmd(strBuddyKey, cmd, strCmd, strHtmlMessage, strPlainMessage, strLogMsg);
		//return (ret == CON_S_OK) ? ATTrue : FALSE;
		bool ret = false;

		if (!CDependence::getInstance()->getFeatureStartFlag())
		{
			CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendIMCmd(), Feature have stopped. Stop sending SendInstantMessageCommand.");
			return ret;
		}// Use work around to fix bug DE2486
		if (GetProvider() != NULL)
		{
			GetProvider()->SendInstantMessageCommand(JCFCoreUtils::toString(strBuddyKey), (InstantMessageCommandCodeEnum::InstantMessageCommandCode)cmd, 
				JCFCoreUtils::toString(strCmd), JCFCoreUtils::toString(strHtmlMessage), 
				JCFCoreUtils::toString(strPlainMessage));
			ret = true;
		}
		return ret;
	}

	bool IMMgrHelper::SendIMCmdEx(const std::string& strBuddyKey, INT cmd, const std::string& strCmd, const std::string& strHtmlMessage, const std::string& strPlainMessage, IN const std::string& strLogMsg)
	{
		bool ret = false;

		if (!CDependence::getInstance()->getFeatureStartFlag())
		{
			CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::SendIMCmd(), Feature have stopped. Stop sending SendInstantMessageCommand.");
			return ret;
		}// Use work around to fix bug DE2486
		if (GetProvider() != NULL)
		{
			GetProvider()->SendGroupChatInstantMessageCommand(strBuddyKey, (InstantMessageCommandCodeEnum::InstantMessageCommandCode)cmd, strCmd, strHtmlMessage, strPlainMessage);
			ret = true;
		}
		return ret;

	}

	InstantMessageConversationService* IMMgrHelper::GetProvider()
	{				
		if (m_pImProvider == NULL)
		{
			m_pImProvider = CDependence::getInstance()->GetUnifiedFactory()->getService<InstantMessageConversationService>().get();
			RegisterImCallback();
		}
		else
		{
			InstantMessageConversationService* pImProvider = CDependence::getInstance()->GetUnifiedFactory()->getService<InstantMessageConversationService>().get();
			if (pImProvider == NULL)
			{
				m_pImProvider = NULL;
				CSFLogInfoS(JabberMeetingIMMgrLogger, "IMMgrHelper::GetProvider InstantMessage service pointer change to NULL");				
			}
			if (pImProvider != m_pImProvider)
			{
				m_pImProvider = pImProvider;
				CSFLogErrorS(JabberMeetingIMMgrLogger, "IMMgrHelper::GetProvider InstantMessage service pointer change");
			}
		}

		return m_pImProvider;
	}

	void IMMgrHelper::RegisterImCallback()
	{
		if (m_pImProvider == NULL)
		{
			return;
		}

		std::vector<InstantMessageCommandCodeEnum::InstantMessageCommandCode>* pCmds = new std::vector<InstantMessageCommandCodeEnum::InstantMessageCommandCode>();
		pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_INVITATION);
		pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_ACCEPT);
		pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_DECLINE);
		pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_CANCELINVITATION);
		pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_MEETING_INVITE);
		pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_MEETING_ACCEPT);
		pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_MEETING_DECLINE);
		pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_MEETING_CANCELINVITATION);
		//pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_WBXMEETING_INVITATE_ATTENDEES);
		pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_WBXMEETING_INVITATE_ATTENDEES_);
		pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_CMR_MEETING_INVITATION);		//add it for CMR with compatible with old client

		SMART_PTR_NS::shared_ptr<std::vector<InstantMessageCommandCodeEnum::InstantMessageCommandCode> > cmds;
		cmds.reset(pCmds);
		if (NULL == m_pCallback)
		{
			m_pCallback.reset(new IMMgrHelperCallback());
		}
		m_pImProvider->RegisterInstantMessageCommandReceivedCallback(m_pCallback, cmds);
	}

	void IMMgrHelper::UnRegisterImCallback()
	{
		if (m_pImProvider == NULL)
		{
			return;
		}
		if (m_pCallback != NULL)
		{
			m_pImProvider->UnregisterInstantMessageCommandReceivedCallback(m_pCallback);
			m_pCallback.reset();
		}		
	}

	void IMMgrHelperCallback::OnInstantMessageCommandReceived(std::string uri, std::string participantUri, InstantMessageCommandCodeEnum::InstantMessageCommandCode commandCode, std::string commandContent, std::string plaintext, std::string richtext, bool isGroupChatCmd)
	{
		if(isGroupChatCmd == true) // if isGroupChatCmd is true should ignore this message. 
		{
			return;
		}
		IJMIMCallback * pCallback = CDependence::getInstance()->GetIMCallback();
		if (NULL == pCallback)
		{
			return;
		}

		JabberWerxCommonHelper* pCommonHelper = CDependence::getInstance()->GetJabberWerxCommonHelper();
		if(NULL == pCommonHelper)
		{
			return;
		}

		wstring strAccountName = pCommonHelper->GetMyAccountName();
		wstring strSessionName = JCFCoreUtils::toWideString(uri);
		wstring strCmdMsg = JCFCoreUtils::toWideString(commandContent);
	
		switch (commandCode)
		{
		case IMCMD_DESKTOPSHARE_INVITATION:
			{
				pCallback->OnRecv_DSInvitation(strAccountName, strSessionName, strCmdMsg);
			}
			break;
		case IMCMD_DESKTOPSHARE_ACCEPT:
			{
				//this IM CMD is not used from C6.5, but we still need set it Handled here because C6 client may send this IM CMD
			}
			break;			
		case IMCMD_DESKTOPSHARE_DECLINE:
			{
				pCallback->OnRecv_DSDecline(strAccountName, strSessionName, strCmdMsg);
			}
			break;
		case IMCMD_DESKTOPSHARE_CANCELINVITATION:
			{
				pCallback->OnRecv_DSCancelled(strAccountName, strSessionName, strCmdMsg);
			}
			break;
			////////////////////////////////////////////////////////////////////////// Meeting
		case IMCMD_MEETING_INVITE:
			{
				pCallback->OnRecv_MeetingInvitation(strAccountName, strSessionName, strCmdMsg);
			}
			break;
		case IMCMD_MEETING_ACCEPT:
			{
				//this IM CMD is not used from C6.5, but we still need set it Handled here because C6 client may send this IM CMD
			}
			break;
		case IMCMD_MEETING_DECLINE:
			{
				pCallback->OnRecv_MeetingDecline(strAccountName, strSessionName, strCmdMsg);
			}
			break;
		case IMCMD_MEETING_CANCELINVITATION:
			{
				pCallback->OnRecv_MeetingCancelled(strAccountName, strSessionName, strCmdMsg);
			}
			break;
		case IMCMD_WBXMEETING_INVITATE_ATTENDEES:
		case IMCMD_WBXMEETING_INVITATE_ATTENDEES_:
			{
				pCallback->OnRecv_IMAlert(strAccountName, strSessionName, strCmdMsg);
			}

		default:
			;
		}

		return;
	}
}


#endif
